/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_destroy_rdma_window.c,v 1.6 2005/06/29 00:23:16 eugene Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "rdma.h"

mx_return_t
mx_destroy_rdma_window(mx_endpoint_t endpoint,
                       uint32_t window_handle){
  int flags;
  uint64_t ptr;
  uint32_t len;
  pthread_mutex_lock(&Mx_po_lock);
  ptr = endpoint->handles.ptr[window_handle];
  len = endpoint->handles.len[window_handle];
  flags = endpoint->handles.flags[window_handle];
  mx_del_window_handle(endpoint, window_handle);
  mx_rdma_disable(ptr, len, flags);
  pthread_mutex_unlock(&Mx_po_lock);
  return MX_SUCCESS;
}
